/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.PacketSyncNPCCount;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandSetMaxHiredNPCs
extends CommandBase {
    private static final int MAX_NPCS = 1000;

    public String func_71517_b() {
        return "setMaxHiredNPCs";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/setMaxHiredNPCs <player> [amount or +amount]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1 || args.length > 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.usage", new Object[0]));
            return;
        }
        EntityPlayerMP targetPlayer = CommandSetMaxHiredNPCs.func_82359_c((ICommandSender)sender, (String)args[0]);
        if (targetPlayer == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.playerNotFound", new Object[0]));
            return;
        }
        LOTRPlayerData playerData = LOTRLevelData.getData((EntityPlayer)targetPlayer);
        if (args.length == 1) {
            if (args[0].equals("get")) {
                int currentMax = playerData.getCustomMaxHiredNPCs();
                if (currentMax == -1) {
                    currentMax = playerData.getMaxHiredNPCs((EntityPlayer)targetPlayer, null);
                }
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.getSuccess", new Object[]{targetPlayer.getDisplayName(), currentMax}));
                return;
            }
            playerData.setCustomMaxHiredNPCs(-1);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.reset", new Object[]{targetPlayer.getDisplayName()}));
            this.syncNPCCountWithClient(targetPlayer, playerData);
        } else {
            int newMax;
            int amount;
            boolean isAddition = args[1].startsWith("+");
            try {
                amount = isAddition ? Integer.parseInt(args[1].substring(1)) : Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.invalidAmount", new Object[0]));
                return;
            }
            if (amount < 0 && !isAddition) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.invalidAmount", new Object[0]));
                return;
            }
            int currentMax = playerData.getCustomMaxHiredNPCs();
            if (currentMax == -1) {
                currentMax = playerData.getMaxHiredNPCs((EntityPlayer)targetPlayer, null);
            }
            int n = newMax = isAddition ? currentMax + amount : amount;
            if (newMax > 1000) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.limitExceeded", new Object[]{1000}));
                return;
            }
            if (isAddition) {
                playerData.setCustomMaxHiredNPCs(currentMax + amount);
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.addSuccess", new Object[]{targetPlayer.getDisplayName(), amount}));
            } else {
                playerData.setCustomMaxHiredNPCs(amount);
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.setMaxHiredNPCs.success", new Object[]{targetPlayer.getDisplayName(), amount}));
            }
            this.syncNPCCountWithClient(targetPlayer, playerData);
        }
    }

    private void syncNPCCountWithClient(EntityPlayerMP player, LOTRPlayerData playerData) {
        int hiredNPCCount = playerData.getGlobalHiredNPCCount();
        int maxHiredNPCs = playerData.getMaxHiredNPCs((EntityPlayer)player, null);
        PacketSyncNPCCount syncPacket = new PacketSyncNPCCount(hiredNPCCount, maxHiredNPCs);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)syncPacket, player);
    }

    public int func_82362_a() {
        return 2;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandSetMaxHiredNPCs.func_71530_a((String[])args, (String[])this.getPlayerNames());
        }
        return null;
    }

    private String[] getPlayerNames() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }
}

